/*
 * Decompiled with CFR 0.152.
 */
package emulator.support;

import emulator.hardware.HwByte;
import emulator.support.CpuState;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class ZeroPageYOperandEval
implements OperandEval {
    MemoryPtr instruction;

    public ZeroPageYOperandEval(MemoryPtr ptr) {
        this.instruction = ptr;
    }

    @Override
    public String getDetails(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int reg_y = cpu_state.getValue("Y");
        int operand = this.instruction.getByteOp();
        this.instruction.setAddress(operand + reg_y & 0xFF);
        String result = "($" + new HwByte((long)operand) + " + $" + new HwByte((long)reg_y) + ") -> $" + new HwByte((long)this.instruction.getByteOp());
        this.instruction.setAddress(old_address);
        return result;
    }

    @Override
    public boolean isAddress() {
        return true;
    }

    @Override
    public int getAddress(CpuState cpu_state) {
        return this.instruction.getByteOp() + cpu_state.getValue("Y") & 0xFF;
    }

    @Override
    public boolean isIndirect() {
        return false;
    }
}

